<?php


class PHPExcel_CachedObjectStorage_Memory extends PHPExcel_CachedObjectStorage_CacheBase implements PHPExcel_CachedObjectStorage_ICache
{
    protected function storeData()
    {
    }
    public function addCacheData($pCoord, PHPExcel_Cell $cell)
    {
        $this->cellCache[$pCoord] = $cell;
        $this->currentObjectID = $pCoord;
        return $cell;
    }
    public function getCacheData($pCoord)
    {
        if (!isset($this->cellCache[$pCoord])) {
            $this->currentObjectID = NULL;
        } else {
            $this->currentObjectID = $pCoord;
            return $this->cellCache[$pCoord];
        }
    }
    public function copyCellCollection(PHPExcel_Worksheet $parent)
    {
        $this::copyCellCollection($parent);
        $newCollection = [];
        $newCollection[$k] = clone $cell;
        $newCollection[$k]->attach($this);
        $this->cellCache = $newCollection;
    }
    public function unsetWorksheetCells()
    {
        $cell->detach();
        $this->cellCache[$k] = NULL;
        unset($cell);
        $this->cellCache = [];
        $this->parent = NULL;
    }
}

?>