<?php


class PHPExcel_Calculation_FormulaParser
{
    private $formula = NULL;
    private $tokens = [];
    const QUOTE_DOUBLE = "\"";
    const QUOTE_SINGLE = "'";
    const BRACKET_CLOSE = "]";
    const BRACKET_OPEN = "[";
    const BRACE_OPEN = "{";
    const BRACE_CLOSE = "}";
    const PAREN_OPEN = "(";
    const PAREN_CLOSE = ")";
    const SEMICOLON = ";";
    const WHITESPACE = " ";
    const COMMA = ",";
    const ERROR_START = "#";
    const OPERATORS_SN = "+-";
    const OPERATORS_INFIX = "+-*/^&=><";
    const OPERATORS_POSTFIX = "%";
    public function __construct($pFormula = "")
    {
        if (is_null($pFormula)) {
            throw new PHPExcel_Calculation_Exception("Invalid parameter passed: formula");
        }
        $this->formula = trim($pFormula);
        $this->parseToTokens();
    }
    public function getFormula()
    {
        return $this->formula;
    }
    public function getToken($pId = 0)
    {
        if (isset($this->tokens[$pId])) {
            return $this->tokens[$pId];
        }
        throw new PHPExcel_Calculation_Exception("Token with id " . $pId . " does not exist.");
    }
    public function getTokenCount()
    {
        return count($this->tokens);
    }
    public function getTokens()
    {
        return $this->tokens;
    }
    private function parseToTokens()
    {
        $formulaLength = strlen($this->formula);
        if ($formulaLength < 2 || $this->formula[0] != "=") {
            return NULL;
        }
        $tokens1 = $tokens2 = $stack = [];
        $inString = $inPath = $inRange = $inError = false;
        $token = $previousToken = $nextToken = NULL;
        $index = 1;
        $value = "";
        $ERRORS = ["#NULL!", "#DIV/0!", "#VALUE!", "#REF!", "#NAME?", "#NUM!", "#N/A"];
        $COMPARATORS_MULTI = [">=", "<=", "<>"];
        while ($index < $formulaLength) {
            if ($inString) {
                if ($this->formula[$index] == "\"") {
                    if ($index + 2 <= $formulaLength && $this->formula[$index + 1] == "\"") {
                        $value .= "\"";
                        $index++;
                    } else {
                        $inString = false;
                        $tokens1[] = new PHPExcel_Calculation_FormulaToken($value, PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERAND, PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_TEXT);
                        $value = "";
                    }
                } else {
                    $value .= $this->formula[$index];
                }
                $index++;
            } else {
                if ($inPath) {
                    if ($this->formula[$index] == "'") {
                        if ($index + 2 <= $formulaLength && $this->formula[$index + 1] == "'") {
                            $value .= "'";
                            $index++;
                        } else {
                            $inPath = false;
                        }
                    } else {
                        $value .= $this->formula[$index];
                    }
                    $index++;
                } else {
                    if ($inRange) {
                        if ($this->formula[$index] == "]") {
                            $inRange = false;
                        }
                        $value .= $this->formula[$index];
                        $index++;
                    } else {
                        if ($inError) {
                            $value .= $this->formula[$index];
                            $index++;
                            if (in_array($value, $ERRORS)) {
                                $inError = false;
                                $tokens1[] = new PHPExcel_Calculation_FormulaToken($value, PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERAND, PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_ERROR);
                                $value = "";
                            }
                        } else {
                            if (strpos("+-", $this->formula[$index]) !== false && 1 < strlen($value) && preg_match("/^[1-9]{1}(\\.[0-9]+)?E{1}\$/", $this->formula[$index]) != 0) {
                                $value .= $this->formula[$index];
                                $index++;
                            } else {
                                if ($this->formula[$index] == "\"") {
                                    if (strlen(0 < $value)) {
                                        $tokens1[] = new PHPExcel_Calculation_FormulaToken($value, PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_UNKNOWN);
                                        $value = "";
                                    }
                                    $inString = true;
                                    $index++;
                                } else {
                                    if ($this->formula[$index] == "'") {
                                        if (0 < strlen($value)) {
                                            $tokens1[] = new PHPExcel_Calculation_FormulaToken($value, PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_UNKNOWN);
                                            $value = "";
                                        }
                                        $inPath = true;
                                        $index++;
                                    } else {
                                        if ($this->formula[$index] == "[") {
                                            $inRange = true;
                                            $value .= "[";
                                            $index++;
                                        } else {
                                            if ($this->formula[$index] == "#") {
                                                if (0 < strlen($value)) {
                                                    $tokens1[] = new PHPExcel_Calculation_FormulaToken($value, PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_UNKNOWN);
                                                    $value = "";
                                                }
                                                $inError = true;
                                                $value .= "#";
                                                $index++;
                                            } else {
                                                if ($this->formula[$index] == "{") {
                                                    if (0 < strlen($value)) {
                                                        $tokens1[] = new PHPExcel_Calculation_FormulaToken($value, PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_UNKNOWN);
                                                        $value = "";
                                                    }
                                                    $tmp = new PHPExcel_Calculation_FormulaToken("ARRAY", PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_FUNCTION, PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_START);
                                                    $tokens1[] = $tmp;
                                                    $stack[] = clone $tmp;
                                                    $tmp = new PHPExcel_Calculation_FormulaToken("ARRAYROW", PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_FUNCTION, PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_START);
                                                    $tokens1[] = $tmp;
                                                    $stack[] = clone $tmp;
                                                    $index++;
                                                } else {
                                                    if ($this->formula[$index] == ";") {
                                                        if (0 < strlen($value)) {
                                                            $tokens1[] = new PHPExcel_Calculation_FormulaToken($value, PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERAND);
                                                            $value = "";
                                                        }
                                                        $tmp = array_pop($stack);
                                                        $tmp->setValue("");
                                                        $tmp->setTokenSubType(PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_STOP);
                                                        $tokens1[] = $tmp;
                                                        $tmp = new PHPExcel_Calculation_FormulaToken(",", PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_ARGUMENT);
                                                        $tokens1[] = $tmp;
                                                        $tmp = new PHPExcel_Calculation_FormulaToken("ARRAYROW", PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_FUNCTION, PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_START);
                                                        $tokens1[] = $tmp;
                                                        $stack[] = clone $tmp;
                                                        $index++;
                                                    } else {
                                                        if ($this->formula[$index] == "}") {
                                                            if (0 < strlen($value)) {
                                                                $tokens1[] = new PHPExcel_Calculation_FormulaToken($value, PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERAND);
                                                                $value = "";
                                                            }
                                                            $tmp = array_pop($stack);
                                                            $tmp->setValue("");
                                                            $tmp->setTokenSubType(PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_STOP);
                                                            $tokens1[] = $tmp;
                                                            $tmp = array_pop($stack);
                                                            $tmp->setValue("");
                                                            $tmp->setTokenSubType(PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_STOP);
                                                            $tokens1[] = $tmp;
                                                            $index++;
                                                        } else {
                                                            if ($this->formula[$index] == " ") {
                                                                if (0 < strlen($value)) {
                                                                    $tokens1[] = new PHPExcel_Calculation_FormulaToken($value, PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERAND);
                                                                    $value = "";
                                                                }
                                                                $tokens1[] = new PHPExcel_Calculation_FormulaToken("", PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_WHITESPACE);
                                                                $index++;
                                                                while ($this->formula[$index] == " " && $index < $formulaLength) {
                                                                    $index++;
                                                                }
                                                            } else {
                                                                if ($index + 2 <= $formulaLength && in_array(substr($this->formula, $index, 2), $COMPARATORS_MULTI)) {
                                                                    if (0 < strlen($value)) {
                                                                        $tokens1[] = new PHPExcel_Calculation_FormulaToken($value, PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERAND);
                                                                        $value = "";
                                                                    }
                                                                    $tokens1[] = new PHPExcel_Calculation_FormulaToken(substr($this->formula, $index, 2), PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERATORINFIX, PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_LOGICAL);
                                                                    $index += 2;
                                                                } else {
                                                                    if (strpos("+-*/^&=><", $this->formula[$index]) !== false) {
                                                                        if (0 < strlen($value)) {
                                                                            $tokens1[] = new PHPExcel_Calculation_FormulaToken($value, PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERAND);
                                                                            $value = "";
                                                                        }
                                                                        $tokens1[] = new PHPExcel_Calculation_FormulaToken($this->formula[$index], PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERATORINFIX);
                                                                        $index++;
                                                                    } else {
                                                                        if (strpos("%", $this->formula[$index]) !== false) {
                                                                            if (0 < strlen($value)) {
                                                                                $tokens1[] = new PHPExcel_Calculation_FormulaToken($value, PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERAND);
                                                                                $value = "";
                                                                            }
                                                                            $tokens1[] = new PHPExcel_Calculation_FormulaToken($this->formula[$index], PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERATORPOSTFIX);
                                                                            $index++;
                                                                        } else {
                                                                            if ($this->formula[$index] == "(") {
                                                                                if (0 < strlen($value)) {
                                                                                    $tmp = new PHPExcel_Calculation_FormulaToken($value, PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_FUNCTION, PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_START);
                                                                                    $tokens1[] = $tmp;
                                                                                    $stack[] = clone $tmp;
                                                                                    $value = "";
                                                                                } else {
                                                                                    $tmp = new PHPExcel_Calculation_FormulaToken("", PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_SUBEXPRESSION, PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_START);
                                                                                    $tokens1[] = $tmp;
                                                                                    $stack[] = clone $tmp;
                                                                                }
                                                                                $index++;
                                                                            } else {
                                                                                if ($this->formula[$index] == ",") {
                                                                                    if (0 < strlen($value)) {
                                                                                        $tokens1[] = new PHPExcel_Calculation_FormulaToken($value, PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERAND);
                                                                                        $value = "";
                                                                                    }
                                                                                    $tmp = array_pop($stack);
                                                                                    $tmp->setValue("");
                                                                                    $tmp->setTokenSubType(PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_STOP);
                                                                                    $stack[] = $tmp;
                                                                                    if ($tmp->getTokenType() == PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_FUNCTION) {
                                                                                        $tokens1[] = new PHPExcel_Calculation_FormulaToken(",", PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERATORINFIX, PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_UNION);
                                                                                    } else {
                                                                                        $tokens1[] = new PHPExcel_Calculation_FormulaToken(",", PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_ARGUMENT);
                                                                                    }
                                                                                    $index++;
                                                                                } else {
                                                                                    if ($this->formula[$index] == ")") {
                                                                                        if (0 < strlen($value)) {
                                                                                            $tokens1[] = new PHPExcel_Calculation_FormulaToken($value, PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERAND);
                                                                                            $value = "";
                                                                                        }
                                                                                        $tmp = array_pop($stack);
                                                                                        $tmp->setValue("");
                                                                                        $tmp->setTokenSubType(PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_STOP);
                                                                                        $tokens1[] = $tmp;
                                                                                        $index++;
                                                                                    } else {
                                                                                        $value .= $this->formula[$index];
                                                                                        $index++;
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (0 < strlen($value)) {
            $tokens1[] = new PHPExcel_Calculation_FormulaToken($value, PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERAND);
        }
        $tokenCount = count($tokens1);
        for ($i = 0; $i < $tokenCount; $i++) {
            $token = $tokens1[$i];
            if (isset($tokens1[$i - 1])) {
                $previousToken = $tokens1[$i - 1];
            } else {
                $previousToken = NULL;
            }
            if (isset($tokens1[$i + 1])) {
                $nextToken = $tokens1[$i + 1];
            } else {
                $nextToken = NULL;
            }
            if (!is_null($token)) {
                if ($token->getTokenType() != PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_WHITESPACE) {
                    $tokens2[] = $token;
                } else {
                    if (!is_null($previousToken)) {
                        if ($previousToken->getTokenType() == PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_FUNCTION && $previousToken->getTokenSubType() == PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_STOP || $previousToken->getTokenType() == PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_SUBEXPRESSION && $previousToken->getTokenSubType() == PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_STOP || $previousToken->getTokenType() == PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERAND) {
                            if (!is_null($nextToken)) {
                                if ($nextToken->getTokenType() == PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_FUNCTION && $nextToken->getTokenSubType() == PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_START || $nextToken->getTokenType() == PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_SUBEXPRESSION && $nextToken->getTokenSubType() == PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_START || $nextToken->getTokenType() == PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERAND) {
                                    $tokens2[] = new PHPExcel_Calculation_FormulaToken($value, PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERATORINFIX, PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_INTERSECTION);
                                }
                            }
                        }
                    }
                }
            }
        }
        $this->tokens = [];
        $tokenCount = count($tokens2);
        for ($i = 0; $i < $tokenCount; $i++) {
            $token = $tokens2[$i];
            if (isset($tokens2[$i - 1])) {
                $previousToken = $tokens2[$i - 1];
            } else {
                $previousToken = NULL;
            }
            if (isset($tokens2[$i + 1])) {
                $nextToken = $tokens2[$i + 1];
            } else {
                $nextToken = NULL;
            }
            if (!is_null($token)) {
                if ($token->getTokenType() == PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERATORINFIX && $token->getValue() == "-") {
                    if ($i == 0) {
                        $token->setTokenType(PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERATORPREFIX);
                    } else {
                        if ($previousToken->getTokenType() == PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_FUNCTION && $previousToken->getTokenSubType() == PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_STOP || $previousToken->getTokenType() == PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_SUBEXPRESSION && $previousToken->getTokenSubType() == PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_STOP || $previousToken->getTokenType() == PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERATORPOSTFIX || $previousToken->getTokenType() == PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERAND) {
                            $token->setTokenSubType(PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_MATH);
                        } else {
                            $token->setTokenType(PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERATORPREFIX);
                        }
                    }
                    $this->tokens[] = $token;
                } else {
                    if ($token->getTokenType() == PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERATORINFIX && $token->getValue() == "+") {
                        if ($i != 0) {
                            if ($previousToken->getTokenType() == PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_FUNCTION && $previousToken->getTokenSubType() == PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_STOP || $previousToken->getTokenType() == PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_SUBEXPRESSION && $previousToken->getTokenSubType() == PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_STOP || $previousToken->getTokenType() == PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERATORPOSTFIX || $previousToken->getTokenType() == PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERAND) {
                                $token->setTokenSubType(PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_MATH);
                                $this->tokens[] = $token;
                            }
                        }
                    } else {
                        if ($token->getTokenType() == PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERATORINFIX && $token->getTokenSubType() == PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_NOTHING) {
                            if (strpos("<>=", substr($token->getValue(), 0, 1)) !== false) {
                                $token->setTokenSubType(PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_LOGICAL);
                            } else {
                                if ($token->getValue() == "&") {
                                    $token->setTokenSubType(PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_CONCATENATION);
                                } else {
                                    $token->setTokenSubType(PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_MATH);
                                }
                            }
                            $this->tokens[] = $token;
                        } else {
                            if ($token->getTokenType() == PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_OPERAND && $token->getTokenSubType() == PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_NOTHING) {
                                if (!is_numeric($token->getValue())) {
                                    if (strtoupper($token->getValue()) == "TRUE" || strtoupper($token->getValue() == "FALSE")) {
                                        $token->setTokenSubType(PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_LOGICAL);
                                    } else {
                                        $token->setTokenSubType(PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_RANGE);
                                    }
                                } else {
                                    $token->setTokenSubType(PHPExcel_Calculation_FormulaToken::TOKEN_SUBTYPE_NUMBER);
                                }
                                $this->tokens[] = $token;
                            } else {
                                if ($token->getTokenType() == PHPExcel_Calculation_FormulaToken::TOKEN_TYPE_FUNCTION && strlen(0 < $token->getValue()) && substr($token->getValue(), 0, 1) == "@") {
                                    $token->setValue(substr($token->getValue(), 1));
                                }
                                $this->tokens[] = $token;
                            }
                        }
                    }
                }
            }
        }
    }
}

?>