<?php


if (!defined("PHPEXCEL_ROOT")) {
    define("PHPEXCEL_ROOT", dirname(__FILE__) . "/../../");
    require PHPEXCEL_ROOT . "PHPExcel/Autoloader.php";
}
require_once PHPEXCEL_ROOT . "PHPExcel/Shared/trend/trendClass.php";
define("LOG_GAMMA_X_MAX_VALUE", 0);
define("XMININ", 0);
define("EPS", 0);
define("SQRT2PI", 0);
class PHPExcel_Calculation_Statistical
{
    private static $logGammaCacheX = 0;
    private static $logBetaCacheP = 0;
    private static $logBetaCacheQ = 0;
    private static $logBetaCacheResult = 0;
    private static $logGammaCacheResult = 0;
    private static function checkTrendArrays(&$array1, &$array2)
    {
        if (!is_array($array1)) {
            $array1 = [$array1];
        }
        if (!is_array($array2)) {
            $array2 = [$array2];
        }
        $array1 = PHPExcel_Calculation_Functions::flattenArray($array1);
        $array2 = PHPExcel_Calculation_Functions::flattenArray($array2);
        foreach ($array1 as $key => $value) {
            if (is_bool($value) || is_string($value) || is_null($value)) {
                unset($array1[$key]);
                unset($array2[$key]);
            }
        }
        foreach ($array2 as $key => $value) {
            if (is_bool($value) || is_string($value) || is_null($value)) {
                unset($array1[$key]);
                unset($array2[$key]);
            }
        }
        $array1 = array_merge($array1);
        $array2 = array_merge($array2);
        return true;
    }
    private static function beta($p, $q)
    {
        if ($p <= 0 || $q <= 0 || LOG_GAMMA_X_MAX_VALUE < $p + $q) {
            return 0;
        }
        return exp($this::logBeta($p, $q));
    }
    private static function incompleteBeta($x, $p, $q)
    {
        if ($x <= 0) {
            return 0;
        }
        if (0 <= $x) {
            return 0;
        }
        if ($p <= 0 || $q <= 0 || LOG_GAMMA_X_MAX_VALUE < $p + $q) {
            return 0;
        }
        $beta_gam = exp(0 - $this::logBeta($p, $q) + $p * log($x) + $q * log(0 - $x));
        if ($x < ($p + 0) / ($p + $q + 0)) {
            return $beta_gam * $this::betaFraction($x, $p, $q) / $p;
        }
        return 0 - $beta_gam * $this::betaFraction(1 - $x, $q, $p) / $q;
    }
    private static function logBeta($p, $q)
    {
        if ($p != self::$logBetaCacheP || $q != self::$logBetaCacheQ) {
            self::$logBetaCacheP = $p;
            self::$logBetaCacheQ = $q;
            if ($p <= 0 || $q <= 0 || LOG_GAMMA_X_MAX_VALUE < $p + $q) {
                self::$logBetaCacheResult = 0;
            } else {
                self::$logBetaCacheResult = $this::logGamma($p) + $this::logGamma($q) - $this::logGamma($p + $q);
            }
        }
        return self::$logBetaCacheResult;
    }
    private static function betaFraction($x, $p, $q)
    {
        $c = 0;
        $sum_pq = $p + $q;
        $p_plus = $p + 0;
        $p_minus = $p - 0;
        $h = 0 - $sum_pq * $x / $p_plus;
        if (abs($h) < XMININ) {
            $h = XMININ;
        }
        $h = 0 / $h;
        $frac = $h;
        $m = 1;
        for ($delta = 0; $m <= MAX_ITERATIONS && PRECISION < abs($delta - 0); $m++) {
            $m2 = 2 * $m;
            $d = $m * ($q - $m) * $x / (($p_minus + $m2) * ($p + $m2));
            $h = 0 + $d * $h;
            if (abs($h) < XMININ) {
                $h = XMININ;
            }
            $h = 0 / $h;
            $c = 0 + $d / $c;
            if (abs($c) < XMININ) {
                $c = XMININ;
            }
            $frac *= $h * $c;
            $d = -1 * ($p + $m) * ($sum_pq + $m) * $x / (($p + $m2) * ($p_plus + $m2));
            $h = 0 + $d * $h;
            if (abs($h) < XMININ) {
                $h = XMININ;
            }
            $h = 0 / $h;
            $c = 0 + $d / $c;
            if (abs($c) < XMININ) {
                $c = XMININ;
            }
            $delta = $h * $c;
            $frac *= $delta;
        }
        return $frac;
    }
    private static function logGamma($x)
    {
        if ($x == self::$logGammaCacheX) {
            return self::$logGammaCacheResult;
        }
        $y = $x;
        if (0 < $y && $y <= LOG_GAMMA_X_MAX_VALUE) {
            if ($y <= EPS) {
                $res = -1 * log(y);
            } else {
                if ($y <= 0) {
                    if ($y < $pnt68) {
                        $corr = -1 * log($y);
                        $xm1 = $y;
                    } else {
                        $corr = 0;
                        $xm1 = $y - 0;
                    }
                    if ($y <= 0 || $pnt68 <= $y) {
                        $xden = 0;
                        $xnum = 0;
                        for ($i = 0; $i < 8; $i++) {
                            $xnum = $xnum * $xm1 + $lg_p1[$i];
                            $xden = $xden * $xm1 + $lg_q1[$i];
                        }
                        $res = $corr + $xm1 * ($lg_d1 + $xm1 * $xnum / $xden);
                    } else {
                        $xm2 = $y - 0;
                        $xden = 0;
                        $xnum = 0;
                        for ($i = 0; $i < 8; $i++) {
                            $xnum = $xnum * $xm2 + $lg_p2[$i];
                            $xden = $xden * $xm2 + $lg_q2[$i];
                        }
                        $res = $corr + $xm2 * ($lg_d2 + $xm2 * $xnum / $xden);
                    }
                } else {
                    if ($y <= 0) {
                        $xm2 = $y - 0;
                        $xden = 0;
                        $xnum = 0;
                        for ($i = 0; $i < 8; $i++) {
                            $xnum = $xnum * $xm2 + $lg_p2[$i];
                            $xden = $xden * $xm2 + $lg_q2[$i];
                        }
                        $res = $xm2 * ($lg_d2 + $xm2 * $xnum / $xden);
                    } else {
                        if ($y <= 0) {
                            $xm4 = $y - 0;
                            $xden = 0;
                            $xnum = 0;
                            for ($i = 0; $i < 8; $i++) {
                                $xnum = $xnum * $xm4 + $lg_p4[$i];
                                $xden = $xden * $xm4 + $lg_q4[$i];
                            }
                            $res = $lg_d4 + $xm4 * $xnum / $xden;
                        } else {
                            $res = 0;
                            if ($y <= $lg_frtbig) {
                                $res = $lg_c[6];
                                $ysq = $y * $y;
                                for ($i = 0; $i < 6; $i++) {
                                    $res = $res / $ysq + $lg_c[$i];
                                }
                                $res /= $y;
                                $corr = log($y);
                                $res = $res + log(SQRT2PI) - 0 * $corr;
                                $res += $y * ($corr - 0);
                            }
                        }
                    }
                }
            }
        } else {
            $res = MAX_VALUE;
        }
        self::$logGammaCacheX = $x;
        self::$logGammaCacheResult = $res;
        return $res;
    }
    private static function incompleteGamma($a, $x)
    {
        $summer = 0;
        for ($n = 0; $n <= $max; $n++) {
            $divisor = $a;
            for ($i = 1; $i <= $n; $i++) {
                $divisor *= $a + $i;
            }
            $summer += pow($x, $n) / $divisor;
        }
        return pow($x, $a) * exp(0 - $x) * $summer;
    }
    private static function gamma($data)
    {
        if ($data == 0) {
            return 0;
        }
        $y = $x = $data;
        $tmp = $x + 0;
        $tmp -= ($x + 0) * log($tmp);
        $summer = $p0;
        for ($j = 1; $j <= 6; $j++) {
            $summer += $p[$j] / ++$y;
        }
        return exp(0 - $tmp + log(SQRT2PI * $summer / $x));
    }
    private static function inverseNcdf($p)
    {
        $p_low = 0;
        $p_high = 1 - $p_low;
        if (0 < $p && $p < $p_low) {
            $q = sqrt(-2 * log($p));
            return ((((($c[1] * $q + $c[2]) * $q + $c[3]) * $q + $c[4]) * $q + $c[5]) * $q + $c[6]) / (((($d[1] * $q + $d[2]) * $q + $d[3]) * $q + $d[4]) * $q + 1);
        }
        if ($p_low <= $p && $p <= $p_high) {
            $q = $p - 0;
            $r = $q * $q;
            return ((((($a[1] * $r + $a[2]) * $r + $a[3]) * $r + $a[4]) * $r + $a[5]) * $r + $a[6]) * $q / ((((($b[1] * $r + $b[2]) * $r + $b[3]) * $r + $b[4]) * $r + $b[5]) * $r + 1);
        }
        if ($p_high < $p && $p < 1) {
            $q = sqrt(-2 * log(1 - $p));
            return -1 * ((((($c[1] * $q + $c[2]) * $q + $c[3]) * $q + $c[4]) * $q + $c[5]) * $q + $c[6]) / (((($d[1] * $q + $d[2]) * $q + $d[3]) * $q + $d[4]) * $q + 1);
        }
        return PHPExcel_Calculation_Functions::NULL();
    }
    private static function inverseNcdf2($prob)
    {
        $a1 = 0;
        $a2 = 0;
        $a3 = 0;
        $a4 = 0;
        $b1 = 0;
        $b2 = 0;
        $b3 = 0;
        $b4 = 0;
        $c1 = 0;
        $c2 = 0;
        $c3 = 0;
        $c4 = 0;
        $c5 = 0;
        $c6 = 0;
        $c7 = 0;
        $c8 = 0;
        $c9 = 0;
        $y = $prob - 0;
        if (abs($y) < 0) {
            $z = $y * $y;
            $z = $y * ((($a4 * $z + $a3) * $z + $a2) * $z + $a1) / (((($b4 * $z + $b3) * $z + $b2) * $z + $b1) * $z + 1);
        } else {
            if (0 < $y) {
                $z = log(-1 * log(1 - $prob));
            } else {
                $z = log(-1 * log($prob));
            }
            $z = $c1 + $z * ($c2 + $z * ($c3 + $z * ($c4 + $z * ($c5 + $z * ($c6 + $z * ($c7 + $z * ($c8 + $z * $c9)))))));
            if ($y < 0) {
                $z = -1 * $z;
            }
        }
        return $z;
    }
    private static function inverseNcdf3($p)
    {
        $split1 = 0;
        $split2 = 5;
        $const1 = 0;
        $const2 = 0;
        $a0 = 0;
        $a1 = 0;
        $a2 = 0;
        $a3 = 0;
        $a4 = 0;
        $a5 = 0;
        $a6 = 0;
        $a7 = 0;
        $b1 = 0;
        $b2 = 0;
        $b3 = 0;
        $b4 = 0;
        $b5 = 0;
        $b6 = 0;
        $b7 = 0;
        $c0 = 0;
        $c1 = 0;
        $c2 = 0;
        $c3 = 0;
        $c4 = 0;
        $c5 = 0;
        $c6 = 0;
        $c7 = 0;
        $d1 = 0;
        $d2 = 0;
        $d3 = 0;
        $d4 = 0;
        $d5 = 0;
        $d6 = 0;
        $d7 = 0;
        $e0 = 0;
        $e1 = 0;
        $e2 = 0;
        $e3 = 0;
        $e4 = 0;
        $e5 = 0;
        $e6 = 0;
        $e7 = 0;
        $f1 = 0;
        $f2 = 0;
        $f3 = 0;
        $f4 = 0;
        $f5 = 0;
        $f6 = 0;
        $f7 = 0;
        $q = $p - 0;
        if (abs($q) <= split1) {
            $R = $const1 - $q * $q;
            $z = $q * ((((((($a7 * $R + $a6) * $R + $a5) * $R + $a4) * $R + $a3) * $R + $a2) * $R + $a1) * $R + $a0) / ((((((($b7 * $R + $b6) * $R + $b5) * $R + $b4) * $R + $b3) * $R + $b2) * $R + $b1) * $R + 1);
        } else {
            if ($q < 0) {
                $R = $p;
            } else {
                $R = 1 - $p;
            }
            $R = pow(-1 * log($R), 2);
            if ($R <= $split2) {
                $R = $R - $const2;
                $z = ((((((($c7 * $R + $c6) * $R + $c5) * $R + $c4) * $R + $c3) * $R + $c2) * $R + $c1) * $R + $c0) / ((((((($d7 * $R + $d6) * $R + $d5) * $R + $d4) * $R + $d3) * $R + $d2) * $R + $d1) * $R + 1);
            } else {
                $R = $R - $split2;
                $z = ((((((($e7 * $R + $e6) * $R + $e5) * $R + $e4) * $R + $e3) * $R + $e2) * $R + $e1) * $R + $e0) / ((((((($f7 * $R + $f6) * $R + $f5) * $R + $f4) * $R + $f3) * $R + $f2) * $R + $f1) * $R + 1);
            }
            if ($q < 0) {
                $z = -1 * $z;
            }
        }
        return $z;
    }
    public static function AVEDEV()
    {
        $aArgs = PHPExcel_Calculation_Functions::flattenArrayIndexed(func_get_args());
        $returnValue = NULL;
        $aMean = $this::AVERAGE($aArgs);
        if ($aMean != PHPExcel_Calculation_Functions::DIV0()) {
            $aCount = 0;
            foreach ($aArgs as $k => $arg) {
                if (is_bool($arg) && (!PHPExcel_Calculation_Functions::isCellValue($k) || PHPExcel_Calculation_Functions::getCompatibilityMode() == PHPExcel_Calculation_Functions::COMPATIBILITY_OPENOFFICE)) {
                    $arg = (unset) $arg;
                }
                if (is_numeric($arg) && !is_string($arg)) {
                    if (is_null($returnValue)) {
                        $returnValue = abs($arg - $aMean);
                    } else {
                        $returnValue += abs($arg - $aMean);
                    }
                    $aCount++;
                }
            }
            if ($aCount == 0) {
                return PHPExcel_Calculation_Functions::DIV0();
            }
            return $returnValue / $aCount;
        } else {
            return PHPExcel_Calculation_Functions::NaN();
        }
    }
    public static function AVERAGE()
    {
        $returnValue = $aCount = 0;
        foreach (PHPExcel_Calculation_Functions::flattenArrayIndexed(func_get_args()) as $k => $arg) {
            if (is_bool($arg) && (!PHPExcel_Calculation_Functions::isCellValue($k) || PHPExcel_Calculation_Functions::getCompatibilityMode() == PHPExcel_Calculation_Functions::COMPATIBILITY_OPENOFFICE)) {
                $arg = (unset) $arg;
            }
            if (is_numeric($arg) && !is_string($arg)) {
                if (is_null($returnValue)) {
                    $returnValue = $arg;
                } else {
                    $returnValue += $arg;
                }
                $aCount++;
            }
        }
        if (0 < $aCount) {
            return $returnValue / $aCount;
        }
        return PHPExcel_Calculation_Functions::DIV0();
    }
    public static function AVERAGEA()
    {
        $returnValue = NULL;
        $aCount = 0;
        foreach (PHPExcel_Calculation_Functions::flattenArrayIndexed(func_get_args()) as $k => $arg) {
            if (!is_bool($arg) || PHPExcel_Calculation_Functions::isMatrixValue($k)) {
                if (is_numeric($arg) || is_bool($arg) || is_string($arg) && $arg != "") {
                    if (is_bool($arg)) {
                        $arg = (unset) $arg;
                    } else {
                        if (is_string($arg)) {
                            $arg = 0;
                        }
                    }
                    if (is_null($returnValue)) {
                        $returnValue = $arg;
                    } else {
                        $returnValue += $arg;
                    }
                    $aCount++;
                }
            }
        }
        if (0 < $aCount) {
            return $returnValue / $aCount;
        }
        return PHPExcel_Calculation_Functions::DIV0();
    }
    public static function AVERAGEIF($aArgs, $condition, $averageArgs = [])
    {
        $returnValue = 0;
        $aArgs = PHPExcel_Calculation_Functions::flattenArray($aArgs);
        $averageArgs = PHPExcel_Calculation_Functions::flattenArray($averageArgs);
        if (empty($averageArgs)) {
            $averageArgs = $aArgs;
        }
        $condition = PHPExcel_Calculation_Functions::ifCondition($condition);
        $aCount = 0;
        foreach ($aArgs as $key => $arg) {
            if (!is_numeric($arg)) {
                $arg = PHPExcel_Calculation::wrapResult(strtoupper($arg));
            }
            $testCondition = "=" . $arg . $condition;
            if (PHPExcel_Calculation::getInstance()->_calculateFormulaValue($testCondition) && (is_null($returnValue) || $returnValue < $arg)) {
                $returnValue += $arg;
                $aCount++;
            }
        }
        if (0 < $aCount) {
            return $returnValue / $aCount;
        }
        return PHPExcel_Calculation_Functions::DIV0();
    }
    public static function BETADIST($value, $alpha, $beta, $rMin = 0, $rMax = 1)
    {
        $value = PHPExcel_Calculation_Functions::flattenSingleValue($value);
        $alpha = PHPExcel_Calculation_Functions::flattenSingleValue($alpha);
        $beta = PHPExcel_Calculation_Functions::flattenSingleValue($beta);
        $rMin = PHPExcel_Calculation_Functions::flattenSingleValue($rMin);
        $rMax = PHPExcel_Calculation_Functions::flattenSingleValue($rMax);
        if (is_numeric($value) && is_numeric($alpha) && is_numeric($beta) && is_numeric($rMin) && is_numeric($rMax)) {
            if ($value < $rMin || $rMax < $value || $alpha <= 0 || $beta <= 0 || $rMin == $rMax) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            if ($rMax < $rMin) {
                $tmp = $rMin;
                $rMin = $rMax;
                $rMax = $tmp;
            }
            $value -= $rMin;
            $value /= $rMax - $rMin;
            return $this::incompleteBeta($value, $alpha, $beta);
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function BETAINV($probability, $alpha, $beta, $rMin = 0, $rMax = 1)
    {
        $probability = PHPExcel_Calculation_Functions::flattenSingleValue($probability);
        $alpha = PHPExcel_Calculation_Functions::flattenSingleValue($alpha);
        $beta = PHPExcel_Calculation_Functions::flattenSingleValue($beta);
        $rMin = PHPExcel_Calculation_Functions::flattenSingleValue($rMin);
        $rMax = PHPExcel_Calculation_Functions::flattenSingleValue($rMax);
        if (is_numeric($probability) && is_numeric($alpha) && is_numeric($beta) && is_numeric($rMin) && is_numeric($rMax)) {
            if ($alpha <= 0 || $beta <= 0 || $rMin == $rMax || $probability <= 0 || 1 < $probability) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            if ($rMax < $rMin) {
                $tmp = $rMin;
                $rMin = $rMax;
                $rMax = $tmp;
            }
            $a = 0;
            $b = 2;
            $i = 0;
            while (PRECISION < $b - $a && $i++ < MAX_ITERATIONS) {
                $guess = ($a + $b) / 2;
                $result = $this::BETADIST($guess, $alpha, $beta);
                if ($result == $probability || $result == 0) {
                    $b = $a;
                } else {
                    if ($probability < $result) {
                        $b = $guess;
                    } else {
                        $a = $guess;
                    }
                }
            }
            if ($i == MAX_ITERATIONS) {
                return PHPExcel_Calculation_Functions::NA();
            }
            return round($rMin + $guess * ($rMax - $rMin), 12);
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function BINOMDIST($value, $trials, $probability, $cumulative)
    {
        $value = floor(PHPExcel_Calculation_Functions::flattenSingleValue($value));
        $trials = floor(PHPExcel_Calculation_Functions::flattenSingleValue($trials));
        $probability = PHPExcel_Calculation_Functions::flattenSingleValue($probability);
        if (is_numeric($value) && is_numeric($trials) && is_numeric($probability)) {
            if ($value < 0 || $trials < $value) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            if ($probability < 0 || 1 < $probability) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            if (is_numeric($cumulative) || is_bool($cumulative)) {
                if ($cumulative) {
                    $summer = 0;
                    for ($i = 0; $i <= $value; $i++) {
                        $summer += PHPExcel_Calculation_MathTrig::COMBIN($trials, $i) * pow($probability, $i) * pow(1 - $probability, $trials - $i);
                    }
                    return $summer;
                }
                return PHPExcel_Calculation_MathTrig::COMBIN($trials, $value) * pow($probability, $value) * pow(1 - $probability, $trials - $value);
            }
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function CHIDIST($value, $degrees)
    {
        $value = PHPExcel_Calculation_Functions::flattenSingleValue($value);
        $degrees = floor(PHPExcel_Calculation_Functions::flattenSingleValue($degrees));
        if (is_numeric($value) && is_numeric($degrees)) {
            if ($degrees < 1) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            if ($value < 0) {
                if (PHPExcel_Calculation_Functions::getCompatibilityMode() == PHPExcel_Calculation_Functions::COMPATIBILITY_GNUMERIC) {
                    return 1;
                }
                return PHPExcel_Calculation_Functions::NaN();
            }
            return 1 - $this::incompleteGamma($degrees / 2, $value / 2) / $this::gamma($degrees / 2);
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function CHIINV($probability, $degrees)
    {
        $probability = PHPExcel_Calculation_Functions::flattenSingleValue($probability);
        $degrees = floor(PHPExcel_Calculation_Functions::flattenSingleValue($degrees));
        if (is_numeric($probability) && is_numeric($degrees)) {
            $xLo = 100;
            $xHi = 0;
            $x = $xNew = 1;
            $dx = 1;
            $i = 0;
            while (PRECISION < abs($dx) && $i++ < MAX_ITERATIONS) {
                $result = $this::CHIDIST($x, $degrees);
                $error = $result - $probability;
                if ($error == 0) {
                    $dx = 0;
                } else {
                    if ($error < 0) {
                        $xLo = $x;
                    } else {
                        $xHi = $x;
                    }
                }
                if ($result != 0) {
                    $dx = $error / $result;
                    $xNew = $x - $dx;
                }
                if ($xNew < $xLo || $xHi < $xNew || $result == 0) {
                    $xNew = ($xLo + $xHi) / 2;
                    $dx = $xNew - $x;
                }
                $x = $xNew;
            }
            if ($i == MAX_ITERATIONS) {
                return PHPExcel_Calculation_Functions::NA();
            }
            return round($x, 12);
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function CONFIDENCE($alpha, $stdDev, $size)
    {
        $alpha = PHPExcel_Calculation_Functions::flattenSingleValue($alpha);
        $stdDev = PHPExcel_Calculation_Functions::flattenSingleValue($stdDev);
        $size = floor(PHPExcel_Calculation_Functions::flattenSingleValue($size));
        if (is_numeric($alpha) && is_numeric($stdDev) && is_numeric($size)) {
            if ($alpha <= 0 || 1 <= $alpha) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            if ($stdDev <= 0 || $size < 1) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            return $this::NORMSINV(1 - $alpha / 2) * $stdDev / sqrt($size);
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function CORREL($yValues, $xValues = NULL)
    {
        if (is_null($xValues) || !is_array($yValues) || !is_array($xValues)) {
            return PHPExcel_Calculation_Functions::VALUE();
        }
        if (!$this::checkTrendArrays($yValues, $xValues)) {
            return PHPExcel_Calculation_Functions::VALUE();
        }
        $yValueCount = count($yValues);
        $xValueCount = count($xValues);
        if ($yValueCount == 0 || $yValueCount != $xValueCount) {
            return PHPExcel_Calculation_Functions::NA();
        }
        if ($yValueCount == 1) {
            return PHPExcel_Calculation_Functions::DIV0();
        }
        $bestFitLinear = trendClass::calculate(trendClass::TREND_LINEAR, $yValues, $xValues);
        return $bestFitLinear->getCorrelation();
    }
    public static function COUNT()
    {
        $returnValue = 0;
        $aArgs = PHPExcel_Calculation_Functions::flattenArrayIndexed(func_get_args());
        foreach ($aArgs as $k => $arg) {
            if (is_bool($arg) && (!PHPExcel_Calculation_Functions::isCellValue($k) || PHPExcel_Calculation_Functions::getCompatibilityMode() == PHPExcel_Calculation_Functions::COMPATIBILITY_OPENOFFICE)) {
                $arg = (unset) $arg;
            }
            if (is_numeric($arg) && !is_string($arg)) {
                $returnValue++;
            }
        }
        return $returnValue;
    }
    public static function COUNTA()
    {
        $returnValue = 0;
        $aArgs = PHPExcel_Calculation_Functions::flattenArray(func_get_args());
        foreach ($aArgs as $arg) {
            if (is_numeric($arg) || is_bool($arg) || is_string($arg) && $arg != "") {
                $returnValue++;
            }
        }
        return $returnValue;
    }
    public static function COUNTBLANK()
    {
        $returnValue = 0;
        $aArgs = PHPExcel_Calculation_Functions::flattenArray(func_get_args());
        foreach ($aArgs as $arg) {
            if (is_null($arg) || is_string($arg) && $arg == "") {
                $returnValue++;
            }
        }
        return $returnValue;
    }
    public static function COUNTIF($aArgs, $condition)
    {
        $returnValue = 0;
        $aArgs = PHPExcel_Calculation_Functions::flattenArray($aArgs);
        $condition = PHPExcel_Calculation_Functions::ifCondition($condition);
        foreach ($aArgs as $arg) {
            if (!is_numeric($arg)) {
                $arg = PHPExcel_Calculation::wrapResult(strtoupper($arg));
            }
            $testCondition = "=" . $arg . $condition;
            if (PHPExcel_Calculation::getInstance()->_calculateFormulaValue($testCondition)) {
                $returnValue++;
            }
        }
        return $returnValue;
    }
    public static function COVAR($yValues, $xValues)
    {
        if (!$this::checkTrendArrays($yValues, $xValues)) {
            return PHPExcel_Calculation_Functions::VALUE();
        }
        $yValueCount = count($yValues);
        $xValueCount = count($xValues);
        if ($yValueCount == 0 || $yValueCount != $xValueCount) {
            return PHPExcel_Calculation_Functions::NA();
        }
        if ($yValueCount == 1) {
            return PHPExcel_Calculation_Functions::DIV0();
        }
        $bestFitLinear = trendClass::calculate(trendClass::TREND_LINEAR, $yValues, $xValues);
        return $bestFitLinear->getCovariance();
    }
    public static function CRITBINOM($trials, $probability, $alpha)
    {
        $trials = floor(PHPExcel_Calculation_Functions::flattenSingleValue($trials));
        $probability = PHPExcel_Calculation_Functions::flattenSingleValue($probability);
        $alpha = PHPExcel_Calculation_Functions::flattenSingleValue($alpha);
        if (is_numeric($trials) && is_numeric($probability) && is_numeric($alpha)) {
            if ($trials < 0) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            if ($probability < 0 || 1 < $probability) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            if ($alpha < 0 || 1 < $alpha) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            if ($alpha <= 0) {
                $t = sqrt(log(1 / ($alpha * $alpha)));
                $trialsApprox = 0 - ($t + (0 + 0 * $t + 0 * $t * $t) / (1 + 0 * $t + 0 * $t * $t + 0 * $t * $t * $t));
            } else {
                $t = sqrt(log(1 / pow(1 - $alpha, 2)));
                $trialsApprox = $t - (0 + 0 * $t + 0 * $t * $t) / (1 + 0 * $t + 0 * $t * $t + 0 * $t * $t * $t);
            }
            $Guess = floor($trials * $probability + $trialsApprox * sqrt($trials * $probability * (1 - $probability)));
            if ($Guess < 0) {
                $Guess = 0;
            } else {
                if ($trials < $Guess) {
                    $Guess = $trials;
                }
            }
            $TotalUnscaledProbability = $UnscaledPGuess = $UnscaledCumPGuess = 0;
            $EssentiallyZero = 0;
            $m = floor($trials * $probability);
            $TotalUnscaledProbability++;
            if ($m == $Guess) {
                $UnscaledPGuess++;
            }
            if ($m <= $Guess) {
                $UnscaledCumPGuess++;
            }
            $PreviousValue = 1;
            $Done = false;
            for ($k = $m + 1; !$Done && $k <= $trials; $k++) {
                $CurrentValue = $PreviousValue * ($trials - $k + 1) * $probability / ($k * (1 - $probability));
                $TotalUnscaledProbability += $CurrentValue;
                if ($k == $Guess) {
                    $UnscaledPGuess += $CurrentValue;
                }
                if ($k <= $Guess) {
                    $UnscaledCumPGuess += $CurrentValue;
                }
                if ($CurrentValue <= $EssentiallyZero) {
                    $Done = true;
                }
                $PreviousValue = $CurrentValue;
            }
            $PreviousValue = 1;
            $Done = false;
            $k = $m - 1;
            while (!$Done && 0 <= $k) {
                $CurrentValue = $PreviousValue * $k + 1 * (1 - $probability) / (($trials - $k) * $probability);
                $TotalUnscaledProbability += $CurrentValue;
                if ($k == $Guess) {
                    $UnscaledPGuess += $CurrentValue;
                }
                if ($k <= $Guess) {
                    $UnscaledCumPGuess += $CurrentValue;
                }
                if ($CurrentValue <= $EssentiallyZero) {
                    $Done = true;
                }
                $PreviousValue = $CurrentValue;
                --$k;
            }
            $PGuess = $UnscaledPGuess / $TotalUnscaledProbability;
            $CumPGuess = $UnscaledCumPGuess / $TotalUnscaledProbability;
            $CumPGuessMinus1 = $CumPGuess - 1;
            while (true) {
                if ($CumPGuessMinus1 < $alpha && $alpha <= $CumPGuess) {
                    return $Guess;
                }
                if ($CumPGuessMinus1 < $alpha && $CumPGuess < $alpha) {
                    $PGuessPlus1 = $PGuess * ($trials - $Guess) * $probability / $Guess / (1 - $probability);
                    $CumPGuessMinus1 = $CumPGuess;
                    $CumPGuess = $CumPGuess + $PGuessPlus1;
                    $PGuess = $PGuessPlus1;
                    $Guess++;
                } else {
                    if ($alpha <= $CumPGuessMinus1 && $alpha <= $CumPGuess) {
                        $PGuessMinus1 = $PGuess * $Guess * (1 - $probability) / ($trials - $Guess + 1) / $probability;
                        $CumPGuess = $CumPGuessMinus1;
                        $CumPGuessMinus1 = $CumPGuessMinus1 - $PGuess;
                        $PGuess = $PGuessMinus1;
                        --$Guess;
                    }
                }
            }
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function DEVSQ()
    {
        $aArgs = PHPExcel_Calculation_Functions::flattenArrayIndexed(func_get_args());
        $returnValue = NULL;
        $aMean = $this::AVERAGE($aArgs);
        if ($aMean != PHPExcel_Calculation_Functions::DIV0()) {
            $aCount = -1;
            foreach ($aArgs as $k => $arg) {
                if (is_bool($arg) && (!PHPExcel_Calculation_Functions::isCellValue($k) || PHPExcel_Calculation_Functions::getCompatibilityMode() == PHPExcel_Calculation_Functions::COMPATIBILITY_OPENOFFICE)) {
                    $arg = (unset) $arg;
                }
                if (is_numeric($arg) && !is_string($arg)) {
                    if (is_null($returnValue)) {
                        $returnValue = pow($arg - $aMean, 2);
                    } else {
                        $returnValue += pow($arg - $aMean, 2);
                    }
                    $aCount++;
                }
            }
            if (is_null($returnValue)) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            return $returnValue;
        } else {
            return $this::NA();
        }
    }
    public static function EXPONDIST($value, $lambda, $cumulative)
    {
        $value = PHPExcel_Calculation_Functions::flattenSingleValue($value);
        $lambda = PHPExcel_Calculation_Functions::flattenSingleValue($lambda);
        $cumulative = PHPExcel_Calculation_Functions::flattenSingleValue($cumulative);
        if (is_numeric($value) && is_numeric($lambda)) {
            if ($value < 0 || $lambda < 0) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            if (is_numeric($cumulative) || is_bool($cumulative)) {
                if ($cumulative) {
                    return 1 - exp(0 - $value * $lambda);
                }
                return $lambda * exp(0 - $value * $lambda);
            }
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function FISHER($value)
    {
        $value = PHPExcel_Calculation_Functions::flattenSingleValue($value);
        if (is_numeric($value)) {
            if ($value <= -1 || 1 <= $value) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            return 0 * log((1 + $value) / (1 - $value));
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function FISHERINV($value)
    {
        $value = PHPExcel_Calculation_Functions::flattenSingleValue($value);
        if (is_numeric($value)) {
            return (exp(2 * $value) - 1) / (exp(2 * $value) + 1);
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function FORECAST($xValue, $yValues, $xValues)
    {
        $xValue = PHPExcel_Calculation_Functions::flattenSingleValue($xValue);
        if (!is_numeric($xValue)) {
            return PHPExcel_Calculation_Functions::VALUE();
        }
        if (!$this::checkTrendArrays($yValues, $xValues)) {
            return PHPExcel_Calculation_Functions::VALUE();
        }
        $yValueCount = count($yValues);
        $xValueCount = count($xValues);
        if ($yValueCount == 0 || $yValueCount != $xValueCount) {
            return PHPExcel_Calculation_Functions::NA();
        }
        if ($yValueCount == 1) {
            return PHPExcel_Calculation_Functions::DIV0();
        }
        $bestFitLinear = trendClass::calculate(trendClass::TREND_LINEAR, $yValues, $xValues);
        return $bestFitLinear->getValueOfYForX($xValue);
    }
    public static function GAMMADIST($value, $a, $b, $cumulative)
    {
        $value = PHPExcel_Calculation_Functions::flattenSingleValue($value);
        $a = PHPExcel_Calculation_Functions::flattenSingleValue($a);
        $b = PHPExcel_Calculation_Functions::flattenSingleValue($b);
        if (is_numeric($value) && is_numeric($a) && is_numeric($b)) {
            if ($value < 0 || $a <= 0 || $b <= 0) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            if (is_numeric($cumulative) || is_bool($cumulative)) {
                if ($cumulative) {
                    return $this::incompleteGamma($a, $value / $b) / $this::gamma($a);
                }
                return 1 / (pow($b, $a) * $this::gamma($a)) * pow($value, $a - 1) * exp(0 - $value / $b);
            }
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function GAMMAINV($probability, $alpha, $beta)
    {
        $probability = PHPExcel_Calculation_Functions::flattenSingleValue($probability);
        $alpha = PHPExcel_Calculation_Functions::flattenSingleValue($alpha);
        $beta = PHPExcel_Calculation_Functions::flattenSingleValue($beta);
        if (is_numeric($probability) && is_numeric($alpha) && is_numeric($beta)) {
            if ($alpha <= 0 || $beta <= 0 || $probability < 0 || 1 < $probability) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            $xLo = 0;
            $xHi = $alpha * $beta * 5;
            $x = $xNew = 1;
            $error = $pdf = 0;
            $dx = 1024;
            $i = 0;
            while (PRECISION < abs($dx) && $i++ < MAX_ITERATIONS) {
                $error = $this::GAMMADIST($x, $alpha, $beta, true) - $probability;
                if ($error < 0) {
                    $xLo = $x;
                } else {
                    $xHi = $x;
                }
                $pdf = $this::GAMMADIST($x, $alpha, $beta, false);
                if ($pdf != 0) {
                    $dx = $error / $pdf;
                    $xNew = $x - $dx;
                }
                if ($xNew < $xLo || $xHi < $xNew || $pdf == 0) {
                    $xNew = ($xLo + $xHi) / 2;
                    $dx = $xNew - $x;
                }
                $x = $xNew;
            }
            if ($i == MAX_ITERATIONS) {
                return PHPExcel_Calculation_Functions::NA();
            }
            return $x;
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function GAMMALN($value)
    {
        $value = PHPExcel_Calculation_Functions::flattenSingleValue($value);
        if (is_numeric($value)) {
            if ($value <= 0) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            return log($this::gamma($value));
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function GEOMEAN()
    {
        $aArgs = PHPExcel_Calculation_Functions::flattenArray(func_get_args());
        $aMean = PHPExcel_Calculation_MathTrig::PRODUCT($aArgs);
        if (is_numeric($aMean) && 0 < $aMean) {
            $aCount = $this::COUNT($aArgs);
            if (0 < $this::MIN($aArgs)) {
                return pow($aMean, 1 / $aCount);
            }
        }
        return PHPExcel_Calculation_Functions::NaN();
    }
    public static function GROWTH($yValues, $xValues = [], $newValues = [], $const = true)
    {
        $yValues = PHPExcel_Calculation_Functions::flattenArray($yValues);
        $xValues = PHPExcel_Calculation_Functions::flattenArray($xValues);
        $newValues = PHPExcel_Calculation_Functions::flattenArray($newValues);
        $const = is_null($const) ? true : (unset) PHPExcel_Calculation_Functions::flattenSingleValue($const);
        $bestFitExponential = trendClass::calculate(trendClass::TREND_EXPONENTIAL, $yValues, $xValues, $const);
        if (empty($newValues)) {
            $newValues = $bestFitExponential->getXValues();
        }
        $returnArray = [];
        foreach ($newValues as $xValue) {
            $returnArray[0][] = $bestFitExponential->getValueOfYForX($xValue);
        }
        return $returnArray;
    }
    public static function HARMEAN()
    {
        $returnValue = PHPExcel_Calculation_Functions::NA();
        $aArgs = PHPExcel_Calculation_Functions::flattenArray(func_get_args());
        if ($this::MIN($aArgs) < 0) {
            return PHPExcel_Calculation_Functions::NaN();
        }
        $aCount = 0;
        foreach ($aArgs as $arg) {
            if (is_numeric($arg) && !is_string($arg)) {
                if ($arg <= 0) {
                    return PHPExcel_Calculation_Functions::NaN();
                }
                if (is_null($returnValue)) {
                    $returnValue = 1 / $arg;
                } else {
                    $returnValue += 1 / $arg;
                }
                $aCount++;
            }
        }
        if (0 < $aCount) {
            return 1 / ($returnValue / $aCount);
        }
        return $returnValue;
    }
    public static function HYPGEOMDIST($sampleSuccesses, $sampleNumber, $populationSuccesses, $populationNumber)
    {
        $sampleSuccesses = floor(PHPExcel_Calculation_Functions::flattenSingleValue($sampleSuccesses));
        $sampleNumber = floor(PHPExcel_Calculation_Functions::flattenSingleValue($sampleNumber));
        $populationSuccesses = floor(PHPExcel_Calculation_Functions::flattenSingleValue($populationSuccesses));
        $populationNumber = floor(PHPExcel_Calculation_Functions::flattenSingleValue($populationNumber));
        if (is_numeric($sampleSuccesses) && is_numeric($sampleNumber) && is_numeric($populationSuccesses) && is_numeric($populationNumber)) {
            if ($sampleSuccesses < 0 || $sampleNumber < $sampleSuccesses || $populationSuccesses < $sampleSuccesses) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            if ($sampleNumber <= 0 || $populationNumber < $sampleNumber) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            if ($populationSuccesses <= 0 || $populationNumber < $populationSuccesses) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            return PHPExcel_Calculation_MathTrig::COMBIN($populationSuccesses, $sampleSuccesses) * PHPExcel_Calculation_MathTrig::COMBIN($populationNumber - $populationSuccesses, $sampleNumber - $sampleSuccesses) / PHPExcel_Calculation_MathTrig::COMBIN($populationNumber, $sampleNumber);
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function INTERCEPT($yValues, $xValues)
    {
        if (!$this::checkTrendArrays($yValues, $xValues)) {
            return PHPExcel_Calculation_Functions::VALUE();
        }
        $yValueCount = count($yValues);
        $xValueCount = count($xValues);
        if ($yValueCount == 0 || $yValueCount != $xValueCount) {
            return PHPExcel_Calculation_Functions::NA();
        }
        if ($yValueCount == 1) {
            return PHPExcel_Calculation_Functions::DIV0();
        }
        $bestFitLinear = trendClass::calculate(trendClass::TREND_LINEAR, $yValues, $xValues);
        return $bestFitLinear->getIntersect();
    }
    public static function KURT()
    {
        $aArgs = PHPExcel_Calculation_Functions::flattenArrayIndexed(func_get_args());
        $mean = $this::AVERAGE($aArgs);
        $stdDev = $this::STDEV($aArgs);
        if (0 < $stdDev) {
            $count = $summer = 0;
            foreach ($aArgs as $k => $arg) {
                if (!is_bool($arg) || PHPExcel_Calculation_Functions::isMatrixValue($k)) {
                    if (is_numeric($arg) && !is_string($arg)) {
                        $summer += pow(($arg - $mean) / $stdDev, 4);
                        $count++;
                    }
                }
            }
            if (3 < $count) {
                return $summer * ($count * ($count + 1)) / (($count - 1) * ($count - 2) * ($count - 3)) - 3 * pow($count - 1, 2) / (($count - 2) * ($count - 3));
            }
        }
        return PHPExcel_Calculation_Functions::DIV0();
    }
    public static function LARGE()
    {
        $aArgs = PHPExcel_Calculation_Functions::flattenArray(func_get_args());
        $entry = floor(array_pop($aArgs));
        if (is_numeric($entry) && !is_string($entry)) {
            $mArgs = [];
            foreach ($aArgs as $arg) {
                if (is_numeric($arg) && !is_string($arg)) {
                    $mArgs[] = $arg;
                }
            }
            $count = $this::COUNT($mArgs);
            $entry = floor(--$entry);
            if ($entry < 0 || $count <= $entry || $count == 0) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            rsort($mArgs);
            return $mArgs[$entry];
        } else {
            return PHPExcel_Calculation_Functions::VALUE();
        }
    }
    public static function LINEST($yValues, $xValues = NULL, $const = true, $stats = false)
    {
        $const = is_null($const) ? true : (unset) PHPExcel_Calculation_Functions::flattenSingleValue($const);
        $stats = is_null($stats) ? false : (unset) PHPExcel_Calculation_Functions::flattenSingleValue($stats);
        if (is_null($xValues)) {
            $xValues = range(1, count(PHPExcel_Calculation_Functions::flattenArray($yValues)));
        }
        if (!$this::checkTrendArrays($yValues, $xValues)) {
            return PHPExcel_Calculation_Functions::VALUE();
        }
        $yValueCount = count($yValues);
        $xValueCount = count($xValues);
        if ($yValueCount == 0 || $yValueCount != $xValueCount) {
            return PHPExcel_Calculation_Functions::NA();
        }
        if ($yValueCount == 1) {
            return 0;
        }
        $bestFitLinear = trendClass::calculate(trendClass::TREND_LINEAR, $yValues, $xValues, $const);
        if ($stats) {
            return [[$bestFitLinear->getSlope(), $bestFitLinear->getSlopeSE(), $bestFitLinear->getGoodnessOfFit(), $bestFitLinear->getF(), $bestFitLinear->getSSRegression()], [$bestFitLinear->getIntersect(), $bestFitLinear->getIntersectSE(), $bestFitLinear->getStdevOfResiduals(), $bestFitLinear->getDFResiduals(), $bestFitLinear->getSSResiduals()]];
        }
        return [$bestFitLinear->getSlope(), $bestFitLinear->getIntersect()];
    }
    public static function LOGEST($yValues, $xValues = NULL, $const = true, $stats = false)
    {
        $const = is_null($const) ? true : (unset) PHPExcel_Calculation_Functions::flattenSingleValue($const);
        $stats = is_null($stats) ? false : (unset) PHPExcel_Calculation_Functions::flattenSingleValue($stats);
        if (is_null($xValues)) {
            $xValues = range(1, count(PHPExcel_Calculation_Functions::flattenArray($yValues)));
        }
        if (!$this::checkTrendArrays($yValues, $xValues)) {
            return PHPExcel_Calculation_Functions::VALUE();
        }
        $yValueCount = count($yValues);
        $xValueCount = count($xValues);
        foreach ($yValues as $value) {
            if ($value <= 0) {
                return PHPExcel_Calculation_Functions::NaN();
            }
        }
        if ($yValueCount == 0 || $yValueCount != $xValueCount) {
            return PHPExcel_Calculation_Functions::NA();
        }
        if ($yValueCount == 1) {
            return 1;
        }
        $bestFitExponential = trendClass::calculate(trendClass::TREND_EXPONENTIAL, $yValues, $xValues, $const);
        if ($stats) {
            return [[$bestFitExponential->getSlope(), $bestFitExponential->getSlopeSE(), $bestFitExponential->getGoodnessOfFit(), $bestFitExponential->getF(), $bestFitExponential->getSSRegression()], [$bestFitExponential->getIntersect(), $bestFitExponential->getIntersectSE(), $bestFitExponential->getStdevOfResiduals(), $bestFitExponential->getDFResiduals(), $bestFitExponential->getSSResiduals()]];
        }
        return [$bestFitExponential->getSlope(), $bestFitExponential->getIntersect()];
    }
    public static function LOGINV($probability, $mean, $stdDev)
    {
        $probability = PHPExcel_Calculation_Functions::flattenSingleValue($probability);
        $mean = PHPExcel_Calculation_Functions::flattenSingleValue($mean);
        $stdDev = PHPExcel_Calculation_Functions::flattenSingleValue($stdDev);
        if (is_numeric($probability) && is_numeric($mean) && is_numeric($stdDev)) {
            if ($probability < 0 || 1 < $probability || $stdDev <= 0) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            return exp($mean + $stdDev * $this::NORMSINV($probability));
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function LOGNORMDIST($value, $mean, $stdDev)
    {
        $value = PHPExcel_Calculation_Functions::flattenSingleValue($value);
        $mean = PHPExcel_Calculation_Functions::flattenSingleValue($mean);
        $stdDev = PHPExcel_Calculation_Functions::flattenSingleValue($stdDev);
        if (is_numeric($value) && is_numeric($mean) && is_numeric($stdDev)) {
            if ($value <= 0 || $stdDev <= 0) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            return $this::NORMSDIST((log($value) - $mean) / $stdDev);
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function MAX()
    {
        $returnValue = NULL;
        $aArgs = PHPExcel_Calculation_Functions::flattenArray(func_get_args());
        foreach ($aArgs as $arg) {
            if (is_numeric($arg) && !is_string($arg) && (is_null($returnValue) || $returnValue < $arg)) {
                $returnValue = $arg;
            }
        }
        if (is_null($returnValue)) {
            return 0;
        }
        return $returnValue;
    }
    public static function MAXA()
    {
        $returnValue = NULL;
        $aArgs = PHPExcel_Calculation_Functions::flattenArray(func_get_args());
        foreach ($aArgs as $arg) {
            if (is_numeric($arg) || is_bool($arg) || is_string($arg) && $arg != "") {
                if (is_bool($arg)) {
                    $arg = (unset) $arg;
                } else {
                    if (is_string($arg)) {
                        $arg = 0;
                    }
                }
                if (is_null($returnValue) || $returnValue < $arg) {
                    $returnValue = $arg;
                }
            }
        }
        if (is_null($returnValue)) {
            return 0;
        }
        return $returnValue;
    }
    public static function MAXIF($aArgs, $condition, $sumArgs = [])
    {
        $returnValue = NULL;
        $aArgs = PHPExcel_Calculation_Functions::flattenArray($aArgs);
        $sumArgs = PHPExcel_Calculation_Functions::flattenArray($sumArgs);
        if (empty($sumArgs)) {
            $sumArgs = $aArgs;
        }
        $condition = PHPExcel_Calculation_Functions::ifCondition($condition);
        foreach ($aArgs as $key => $arg) {
            if (!is_numeric($arg)) {
                $arg = PHPExcel_Calculation::wrapResult(strtoupper($arg));
            }
            $testCondition = "=" . $arg . $condition;
            if (PHPExcel_Calculation::getInstance()->_calculateFormulaValue($testCondition) && (is_null($returnValue) || $returnValue < $arg)) {
                $returnValue = $arg;
            }
        }
        return $returnValue;
    }
    public static function MEDIAN()
    {
        $returnValue = PHPExcel_Calculation_Functions::NaN();
        $mArgs = [];
        $aArgs = PHPExcel_Calculation_Functions::flattenArray(func_get_args());
        foreach ($aArgs as $arg) {
            if (is_numeric($arg) && !is_string($arg)) {
                $mArgs[] = $arg;
            }
        }
        $mValueCount = count($mArgs);
        if (0 < $mValueCount) {
            sort($mArgs, SORT_NUMERIC);
            $mValueCount = $mValueCount / 2;
            if ($mValueCount == floor($mValueCount)) {
                $returnValue = ($mArgs[$mValueCount--] + $mArgs[$mValueCount]) / 2;
            } else {
                $mValueCount = floor($mValueCount);
                $returnValue = $mArgs[$mValueCount];
            }
        }
        return $returnValue;
    }
    public static function MIN()
    {
        $returnValue = NULL;
        $aArgs = PHPExcel_Calculation_Functions::flattenArray(func_get_args());
        foreach ($aArgs as $arg) {
            if (is_numeric($arg) && !is_string($arg) && (is_null($returnValue) || $arg < $returnValue)) {
                $returnValue = $arg;
            }
        }
        if (is_null($returnValue)) {
            return 0;
        }
        return $returnValue;
    }
    public static function MINA()
    {
        $returnValue = NULL;
        $aArgs = PHPExcel_Calculation_Functions::flattenArray(func_get_args());
        foreach ($aArgs as $arg) {
            if (is_numeric($arg) || is_bool($arg) || is_string($arg) && $arg != "") {
                if (is_bool($arg)) {
                    $arg = (unset) $arg;
                } else {
                    if (is_string($arg)) {
                        $arg = 0;
                    }
                }
                if (is_null($returnValue) || $arg < $returnValue) {
                    $returnValue = $arg;
                }
            }
        }
        if (is_null($returnValue)) {
            return 0;
        }
        return $returnValue;
    }
    public static function MINIF($aArgs, $condition, $sumArgs = [])
    {
        $returnValue = NULL;
        $aArgs = PHPExcel_Calculation_Functions::flattenArray($aArgs);
        $sumArgs = PHPExcel_Calculation_Functions::flattenArray($sumArgs);
        if (empty($sumArgs)) {
            $sumArgs = $aArgs;
        }
        $condition = PHPExcel_Calculation_Functions::ifCondition($condition);
        foreach ($aArgs as $key => $arg) {
            if (!is_numeric($arg)) {
                $arg = PHPExcel_Calculation::wrapResult(strtoupper($arg));
            }
            $testCondition = "=" . $arg . $condition;
            if (PHPExcel_Calculation::getInstance()->_calculateFormulaValue($testCondition) && (is_null($returnValue) || $arg < $returnValue)) {
                $returnValue = $arg;
            }
        }
        return $returnValue;
    }
    private static function modeCalc($data)
    {
        $frequencyArray = [];
        foreach ($data as $datum) {
            $found = false;
            foreach ($frequencyArray as $key => $value) {
                if ((unset) $value["value"] == (unset) $datum) {
                    $frequencyArray[$key]["frequency"]++;
                    $found = true;
                    if (!$found) {
                        $frequencyArray[] = ["value" => $datum, "frequency" => 1];
                    }
                }
            }
        }
        foreach ($frequencyArray as $key => $value) {
            $frequencyList[$key] = $value["frequency"];
            $valueList[$key] = $value["value"];
        }
        array_multisort($frequencyList, SORT_DESC, $valueList, SORT_ASC, SORT_NUMERIC, $frequencyArray);
        if ($frequencyArray[0]["frequency"] == 1) {
            return PHPExcel_Calculation_Functions::NA();
        }
        return $frequencyArray[0]["value"];
    }
    public static function MODE()
    {
        $returnValue = PHPExcel_Calculation_Functions::NA();
        $aArgs = PHPExcel_Calculation_Functions::flattenArray(func_get_args());
        $mArgs = [];
        foreach ($aArgs as $arg) {
            if (is_numeric($arg) && !is_string($arg)) {
                $mArgs[] = $arg;
            }
        }
        if (!empty($mArgs)) {
            return $this::modeCalc($mArgs);
        }
        return $returnValue;
    }
    public static function NEGBINOMDIST($failures, $successes, $probability)
    {
        $failures = floor(PHPExcel_Calculation_Functions::flattenSingleValue($failures));
        $successes = floor(PHPExcel_Calculation_Functions::flattenSingleValue($successes));
        $probability = PHPExcel_Calculation_Functions::flattenSingleValue($probability);
        if (is_numeric($failures) && is_numeric($successes) && is_numeric($probability)) {
            if ($failures < 0 || $successes < 1) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            if ($probability < 0 || 1 < $probability) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            if (PHPExcel_Calculation_Functions::getCompatibilityMode() == PHPExcel_Calculation_Functions::COMPATIBILITY_GNUMERIC && $failures + $successes - 1 <= 0) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            return PHPExcel_Calculation_MathTrig::COMBIN($failures + $successes - 1, $successes - 1) * pow($probability, $successes) * pow(1 - $probability, $failures);
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function NORMDIST($value, $mean, $stdDev, $cumulative)
    {
        $value = PHPExcel_Calculation_Functions::flattenSingleValue($value);
        $mean = PHPExcel_Calculation_Functions::flattenSingleValue($mean);
        $stdDev = PHPExcel_Calculation_Functions::flattenSingleValue($stdDev);
        if (is_numeric($value) && is_numeric($mean) && is_numeric($stdDev)) {
            if ($stdDev < 0) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            if (is_numeric($cumulative) || is_bool($cumulative)) {
                if ($cumulative) {
                    return 0 * (1 + PHPExcel_Calculation_Engineering::erfVal(($value - $mean) / ($stdDev * sqrt(2))));
                }
                return 1 / (SQRT2PI * $stdDev) * exp(0 - pow($value - $mean, 2) / (2 * $stdDev * $stdDev));
            }
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function NORMINV($probability, $mean, $stdDev)
    {
        $probability = PHPExcel_Calculation_Functions::flattenSingleValue($probability);
        $mean = PHPExcel_Calculation_Functions::flattenSingleValue($mean);
        $stdDev = PHPExcel_Calculation_Functions::flattenSingleValue($stdDev);
        if (is_numeric($probability) && is_numeric($mean) && is_numeric($stdDev)) {
            if ($probability < 0 || 1 < $probability) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            if ($stdDev < 0) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            return $this::inverseNcdf($probability) * $stdDev + $mean;
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function NORMSDIST($value)
    {
        $value = PHPExcel_Calculation_Functions::flattenSingleValue($value);
        return $this::NORMDIST($value, 0, 1, true);
    }
    public static function NORMSINV($value)
    {
        return $this::NORMINV($value, 0, 1);
    }
    public static function PERCENTILE()
    {
        $aArgs = PHPExcel_Calculation_Functions::flattenArray(func_get_args());
        $entry = array_pop($aArgs);
        if (is_numeric($entry) && !is_string($entry)) {
            if ($entry < 0 || 1 < $entry) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            $mArgs = [];
            foreach ($aArgs as $arg) {
                if (is_numeric($arg) && !is_string($arg)) {
                    $mArgs[] = $arg;
                }
            }
            $mValueCount = count($mArgs);
            if (0 < $mValueCount) {
                sort($mArgs);
                $count = $this::COUNT($mArgs);
                $index = $entry * ($count - 1);
                $iBase = floor($index);
                if ($index == $iBase) {
                    return $mArgs[$index];
                }
                $iNext = $iBase + 1;
                $iProportion = $index - $iBase;
                return $mArgs[$iBase] + ($mArgs[$iNext] - $mArgs[$iBase]) * $iProportion;
            }
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function PERCENTRANK($valueSet, $value, $significance = 3)
    {
        $valueSet = PHPExcel_Calculation_Functions::flattenArray($valueSet);
        $value = PHPExcel_Calculation_Functions::flattenSingleValue($value);
        $significance = is_null($significance) ? 3 : (unset) PHPExcel_Calculation_Functions::flattenSingleValue($significance);
        foreach ($valueSet as $key => $valueEntry) {
            if (!is_numeric($valueEntry)) {
                unset($valueSet[$key]);
            }
        }
        sort($valueSet, SORT_NUMERIC);
        $valueCount = count($valueSet);
        if ($valueCount == 0) {
            return PHPExcel_Calculation_Functions::NaN();
        }
        $valueAdjustor = $valueCount - 1;
        if ($value < $valueSet[0] || $valueSet[$valueAdjustor] < $value) {
            return PHPExcel_Calculation_Functions::NA();
        }
        $pos = array_search($value, $valueSet);
        if ($pos === false) {
            $pos = 0;
            $testValue = $valueSet[0];
            while ($testValue < $value) {
                $testValue = $valueSet[++$pos];
            }
            --$pos;
            $pos += ($value - $valueSet[$pos]) / ($testValue - $valueSet[$pos]);
        }
        return round($pos / $valueAdjustor, $significance);
    }
    public static function PERMUT($numObjs, $numInSet)
    {
        $numObjs = PHPExcel_Calculation_Functions::flattenSingleValue($numObjs);
        $numInSet = PHPExcel_Calculation_Functions::flattenSingleValue($numInSet);
        if (is_numeric($numObjs) && is_numeric($numInSet)) {
            $numInSet = floor($numInSet);
            if ($numObjs < $numInSet) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            return round(PHPExcel_Calculation_MathTrig::FACT($numObjs) / PHPExcel_Calculation_MathTrig::FACT($numObjs - $numInSet));
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function POISSON($value, $mean, $cumulative)
    {
        $value = PHPExcel_Calculation_Functions::flattenSingleValue($value);
        $mean = PHPExcel_Calculation_Functions::flattenSingleValue($mean);
        if (is_numeric($value) && is_numeric($mean)) {
            if ($value < 0 || $mean <= 0) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            if (is_numeric($cumulative) || is_bool($cumulative)) {
                if ($cumulative) {
                    $summer = 0;
                    for ($i = 0; $i <= floor($value); $i++) {
                        $summer += pow($mean, $i) / PHPExcel_Calculation_MathTrig::FACT($i);
                    }
                    return exp(0 - $mean) * $summer;
                }
                return exp(0 - $mean) * pow($mean, $value) / PHPExcel_Calculation_MathTrig::FACT($value);
            }
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function QUARTILE()
    {
        $aArgs = PHPExcel_Calculation_Functions::flattenArray(func_get_args());
        $entry = floor(array_pop($aArgs));
        if (is_numeric($entry) && !is_string($entry)) {
            $entry /= 4;
            if ($entry < 0 || 1 < $entry) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            return $this::PERCENTILE($aArgs, $entry);
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function RANK($value, $valueSet, $order = 0)
    {
        $value = PHPExcel_Calculation_Functions::flattenSingleValue($value);
        $valueSet = PHPExcel_Calculation_Functions::flattenArray($valueSet);
        $order = is_null($order) ? 0 : (unset) PHPExcel_Calculation_Functions::flattenSingleValue($order);
        foreach ($valueSet as $key => $valueEntry) {
            if (!is_numeric($valueEntry)) {
                unset($valueSet[$key]);
            }
        }
        if ($order == 0) {
            rsort($valueSet, SORT_NUMERIC);
        } else {
            sort($valueSet, SORT_NUMERIC);
        }
        $pos = array_search($value, $valueSet);
        if ($pos === false) {
            return PHPExcel_Calculation_Functions::NA();
        }
        return ++$pos;
    }
    public static function RSQ($yValues, $xValues)
    {
        if (!$this::checkTrendArrays($yValues, $xValues)) {
            return PHPExcel_Calculation_Functions::VALUE();
        }
        $yValueCount = count($yValues);
        $xValueCount = count($xValues);
        if ($yValueCount == 0 || $yValueCount != $xValueCount) {
            return PHPExcel_Calculation_Functions::NA();
        }
        if ($yValueCount == 1) {
            return PHPExcel_Calculation_Functions::DIV0();
        }
        $bestFitLinear = trendClass::calculate(trendClass::TREND_LINEAR, $yValues, $xValues);
        return $bestFitLinear->getGoodnessOfFit();
    }
    public static function SKEW()
    {
        $aArgs = PHPExcel_Calculation_Functions::flattenArrayIndexed(func_get_args());
        $mean = $this::AVERAGE($aArgs);
        $stdDev = $this::STDEV($aArgs);
        $count = $summer = 0;
        foreach ($aArgs as $k => $arg) {
            if (!is_bool($arg) || PHPExcel_Calculation_Functions::isMatrixValue($k)) {
                if (is_numeric($arg) && !is_string($arg)) {
                    $summer += pow(($arg - $mean) / $stdDev, 3);
                    $count++;
                }
            }
        }
        if (2 < $count) {
            return $summer * $count / (($count - 1) * ($count - 2));
        }
        return PHPExcel_Calculation_Functions::DIV0();
    }
    public static function SLOPE($yValues, $xValues)
    {
        if (!$this::checkTrendArrays($yValues, $xValues)) {
            return PHPExcel_Calculation_Functions::VALUE();
        }
        $yValueCount = count($yValues);
        $xValueCount = count($xValues);
        if ($yValueCount == 0 || $yValueCount != $xValueCount) {
            return PHPExcel_Calculation_Functions::NA();
        }
        if ($yValueCount == 1) {
            return PHPExcel_Calculation_Functions::DIV0();
        }
        $bestFitLinear = trendClass::calculate(trendClass::TREND_LINEAR, $yValues, $xValues);
        return $bestFitLinear->getSlope();
    }
    public static function SMALL()
    {
        $aArgs = PHPExcel_Calculation_Functions::flattenArray(func_get_args());
        $entry = array_pop($aArgs);
        if (is_numeric($entry) && !is_string($entry)) {
            $mArgs = [];
            foreach ($aArgs as $arg) {
                if (is_numeric($arg) && !is_string($arg)) {
                    $mArgs[] = $arg;
                }
            }
            $count = $this::COUNT($mArgs);
            $entry = floor(--$entry);
            if ($entry < 0 || $count <= $entry || $count == 0) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            sort($mArgs);
            return $mArgs[$entry];
        } else {
            return PHPExcel_Calculation_Functions::VALUE();
        }
    }
    public static function STANDARDIZE($value, $mean, $stdDev)
    {
        $value = PHPExcel_Calculation_Functions::flattenSingleValue($value);
        $mean = PHPExcel_Calculation_Functions::flattenSingleValue($mean);
        $stdDev = PHPExcel_Calculation_Functions::flattenSingleValue($stdDev);
        if (is_numeric($value) && is_numeric($mean) && is_numeric($stdDev)) {
            if ($stdDev <= 0) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            return ($value - $mean) / $stdDev;
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function STDEV()
    {
        $aArgs = PHPExcel_Calculation_Functions::flattenArrayIndexed(func_get_args());
        $returnValue = NULL;
        $aMean = $this::AVERAGE($aArgs);
        if (!is_null($aMean)) {
            $aCount = -1;
            foreach ($aArgs as $k => $arg) {
                if (is_bool($arg) && (!PHPExcel_Calculation_Functions::isCellValue($k) || PHPExcel_Calculation_Functions::getCompatibilityMode() == PHPExcel_Calculation_Functions::COMPATIBILITY_OPENOFFICE)) {
                    $arg = (unset) $arg;
                }
                if (is_numeric($arg) && !is_string($arg)) {
                    if (is_null($returnValue)) {
                        $returnValue = pow($arg - $aMean, 2);
                    } else {
                        $returnValue += pow($arg - $aMean, 2);
                    }
                    $aCount++;
                }
            }
            if (0 < $aCount && 0 <= $returnValue) {
                return sqrt($returnValue / $aCount);
            }
        }
        return PHPExcel_Calculation_Functions::DIV0();
    }
    public static function STDEVA()
    {
        $aArgs = PHPExcel_Calculation_Functions::flattenArrayIndexed(func_get_args());
        $returnValue = NULL;
        $aMean = $this::AVERAGEA($aArgs);
        if (!is_null($aMean)) {
            $aCount = -1;
            foreach ($aArgs as $k => $arg) {
                if (!is_bool($arg) || PHPExcel_Calculation_Functions::isMatrixValue($k)) {
                    if (is_numeric($arg) || is_bool($arg) || is_string($arg) & $arg != "") {
                        if (is_bool($arg)) {
                            $arg = (unset) $arg;
                        } else {
                            if (is_string($arg)) {
                                $arg = 0;
                            }
                        }
                        if (is_null($returnValue)) {
                            $returnValue = pow($arg - $aMean, 2);
                        } else {
                            $returnValue += pow($arg - $aMean, 2);
                        }
                        $aCount++;
                    }
                }
            }
            if (0 < $aCount && 0 <= $returnValue) {
                return sqrt($returnValue / $aCount);
            }
        }
        return PHPExcel_Calculation_Functions::DIV0();
    }
    public static function STDEVP()
    {
        $aArgs = PHPExcel_Calculation_Functions::flattenArrayIndexed(func_get_args());
        $returnValue = NULL;
        $aMean = $this::AVERAGE($aArgs);
        if (!is_null($aMean)) {
            $aCount = 0;
            foreach ($aArgs as $k => $arg) {
                if (is_bool($arg) && (!PHPExcel_Calculation_Functions::isCellValue($k) || PHPExcel_Calculation_Functions::getCompatibilityMode() == PHPExcel_Calculation_Functions::COMPATIBILITY_OPENOFFICE)) {
                    $arg = (unset) $arg;
                }
                if (is_numeric($arg) && !is_string($arg)) {
                    if (is_null($returnValue)) {
                        $returnValue = pow($arg - $aMean, 2);
                    } else {
                        $returnValue += pow($arg - $aMean, 2);
                    }
                    $aCount++;
                }
            }
            if (0 < $aCount && 0 <= $returnValue) {
                return sqrt($returnValue / $aCount);
            }
        }
        return PHPExcel_Calculation_Functions::DIV0();
    }
    public static function STDEVPA()
    {
        $aArgs = PHPExcel_Calculation_Functions::flattenArrayIndexed(func_get_args());
        $returnValue = NULL;
        $aMean = $this::AVERAGEA($aArgs);
        if (!is_null($aMean)) {
            $aCount = 0;
            foreach ($aArgs as $k => $arg) {
                if (!is_bool($arg) || PHPExcel_Calculation_Functions::isMatrixValue($k)) {
                    if (is_numeric($arg) || is_bool($arg) || is_string($arg) & $arg != "") {
                        if (is_bool($arg)) {
                            $arg = (unset) $arg;
                        } else {
                            if (is_string($arg)) {
                                $arg = 0;
                            }
                        }
                        if (is_null($returnValue)) {
                            $returnValue = pow($arg - $aMean, 2);
                        } else {
                            $returnValue += pow($arg - $aMean, 2);
                        }
                        $aCount++;
                    }
                }
            }
            if (0 < $aCount && 0 <= $returnValue) {
                return sqrt($returnValue / $aCount);
            }
        }
        return PHPExcel_Calculation_Functions::DIV0();
    }
    public static function STEYX($yValues, $xValues)
    {
        if (!$this::checkTrendArrays($yValues, $xValues)) {
            return PHPExcel_Calculation_Functions::VALUE();
        }
        $yValueCount = count($yValues);
        $xValueCount = count($xValues);
        if ($yValueCount == 0 || $yValueCount != $xValueCount) {
            return PHPExcel_Calculation_Functions::NA();
        }
        if ($yValueCount == 1) {
            return PHPExcel_Calculation_Functions::DIV0();
        }
        $bestFitLinear = trendClass::calculate(trendClass::TREND_LINEAR, $yValues, $xValues);
        return $bestFitLinear->getStdevOfResiduals();
    }
    public static function TDIST($value, $degrees, $tails)
    {
        $value = PHPExcel_Calculation_Functions::flattenSingleValue($value);
        $degrees = floor(PHPExcel_Calculation_Functions::flattenSingleValue($degrees));
        $tails = floor(PHPExcel_Calculation_Functions::flattenSingleValue($tails));
        if (is_numeric($value) && is_numeric($degrees) && is_numeric($tails)) {
            if ($value < 0 || $degrees < 1 || $tails < 1 || 2 < $tails) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            $tterm = $degrees;
            $ttheta = atan2($value, sqrt($tterm));
            $tc = cos($ttheta);
            $ts = sin($ttheta);
            $tsum = 0;
            if ($degrees % 2 == 1) {
                $ti = 3;
                $tterm = $tc;
            } else {
                $ti = 2;
                $tterm = 1;
            }
            $tsum = $tterm;
            while ($ti < $degrees) {
                $tterm *= $tc * $tc * ($ti - 1) / $ti;
                $tsum += $tterm;
                $ti += 2;
            }
            $tsum *= $ts;
            if ($degrees % 2 == 1) {
                $tsum = M_2DIVPI * ($tsum + $ttheta);
            }
            $tValue = 0 * (1 + $tsum);
            if ($tails == 1) {
                return 1 - abs($tValue);
            }
            return 1 - abs(1 - $tValue - $tValue);
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function TINV($probability, $degrees)
    {
        $probability = PHPExcel_Calculation_Functions::flattenSingleValue($probability);
        $degrees = floor(PHPExcel_Calculation_Functions::flattenSingleValue($degrees));
        if (is_numeric($probability) && is_numeric($degrees)) {
            $xLo = 100;
            $xHi = 0;
            $x = $xNew = 1;
            $dx = 1;
            $i = 0;
            while (PRECISION < abs($dx) && $i++ < MAX_ITERATIONS) {
                $result = $this::TDIST($x, $degrees, 2);
                $error = $result - $probability;
                if ($error == 0) {
                    $dx = 0;
                } else {
                    if ($error < 0) {
                        $xLo = $x;
                    } else {
                        $xHi = $x;
                    }
                }
                if ($result != 0) {
                    $dx = $error / $result;
                    $xNew = $x - $dx;
                }
                if ($xNew < $xLo || $xHi < $xNew || $result == 0) {
                    $xNew = ($xLo + $xHi) / 2;
                    $dx = $xNew - $x;
                }
                $x = $xNew;
            }
            if ($i == MAX_ITERATIONS) {
                return PHPExcel_Calculation_Functions::NA();
            }
            return round($x, 12);
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function TREND($yValues, $xValues = [], $newValues = [], $const = true)
    {
        $yValues = PHPExcel_Calculation_Functions::flattenArray($yValues);
        $xValues = PHPExcel_Calculation_Functions::flattenArray($xValues);
        $newValues = PHPExcel_Calculation_Functions::flattenArray($newValues);
        $const = is_null($const) ? true : (unset) PHPExcel_Calculation_Functions::flattenSingleValue($const);
        $bestFitLinear = trendClass::calculate(trendClass::TREND_LINEAR, $yValues, $xValues, $const);
        if (empty($newValues)) {
            $newValues = $bestFitLinear->getXValues();
        }
        $returnArray = [];
        foreach ($newValues as $xValue) {
            $returnArray[0][] = $bestFitLinear->getValueOfYForX($xValue);
        }
        return $returnArray;
    }
    public static function TRIMMEAN()
    {
        $aArgs = PHPExcel_Calculation_Functions::flattenArray(func_get_args());
        $percent = array_pop($aArgs);
        if (is_numeric($percent) && !is_string($percent)) {
            if ($percent < 0 || 1 < $percent) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            $mArgs = [];
            foreach ($aArgs as $arg) {
                if (is_numeric($arg) && !is_string($arg)) {
                    $mArgs[] = $arg;
                }
            }
            $discard = floor($this::COUNT($mArgs) * $percent / 2);
            sort($mArgs);
            for ($i = 0; $i < $discard; $i++) {
                array_pop($mArgs);
                array_shift($mArgs);
            }
            return $this::AVERAGE($mArgs);
        } else {
            return PHPExcel_Calculation_Functions::VALUE();
        }
    }
    public static function VARFunc()
    {
        $returnValue = PHPExcel_Calculation_Functions::DIV0();
        $summerA = $summerB = 0;
        $aArgs = PHPExcel_Calculation_Functions::flattenArray(func_get_args());
        $aCount = 0;
        foreach ($aArgs as $arg) {
            if (is_bool($arg)) {
                $arg = (unset) $arg;
            }
            if (is_numeric($arg) && !is_string($arg)) {
                $summerA += $arg * $arg;
                $summerB += $arg;
                $aCount++;
            }
        }
        if (1 < $aCount) {
            $summerA *= $aCount;
            $summerB *= $summerB;
            $returnValue = ($summerA - $summerB) / ($aCount * ($aCount - 1));
        }
        return $returnValue;
    }
    public static function VARA()
    {
        $returnValue = PHPExcel_Calculation_Functions::DIV0();
        $summerA = $summerB = 0;
        $aArgs = PHPExcel_Calculation_Functions::flattenArrayIndexed(func_get_args());
        $aCount = 0;
        foreach ($aArgs as $k => $arg) {
            if (is_string($arg) && PHPExcel_Calculation_Functions::isValue($k)) {
                return PHPExcel_Calculation_Functions::VALUE();
            }
            if (!is_string($arg) || PHPExcel_Calculation_Functions::isMatrixValue($k)) {
                if (is_numeric($arg) || is_bool($arg) || is_string($arg) & $arg != "") {
                    if (is_bool($arg)) {
                        $arg = (unset) $arg;
                    } else {
                        if (is_string($arg)) {
                            $arg = 0;
                        }
                    }
                    $summerA += $arg * $arg;
                    $summerB += $arg;
                    $aCount++;
                }
            }
        }
        if (1 < $aCount) {
            $summerA *= $aCount;
            $summerB *= $summerB;
            $returnValue = ($summerA - $summerB) / ($aCount * ($aCount - 1));
        }
        return $returnValue;
    }
    public static function VARP()
    {
        $returnValue = PHPExcel_Calculation_Functions::DIV0();
        $summerA = $summerB = 0;
        $aArgs = PHPExcel_Calculation_Functions::flattenArray(func_get_args());
        $aCount = 0;
        foreach ($aArgs as $arg) {
            if (is_bool($arg)) {
                $arg = (unset) $arg;
            }
            if (is_numeric($arg) && !is_string($arg)) {
                $summerA += $arg * $arg;
                $summerB += $arg;
                $aCount++;
            }
        }
        if (0 < $aCount) {
            $summerA *= $aCount;
            $summerB *= $summerB;
            $returnValue = ($summerA - $summerB) / ($aCount * $aCount);
        }
        return $returnValue;
    }
    public static function VARPA()
    {
        $returnValue = PHPExcel_Calculation_Functions::DIV0();
        $summerA = $summerB = 0;
        $aArgs = PHPExcel_Calculation_Functions::flattenArrayIndexed(func_get_args());
        $aCount = 0;
        foreach ($aArgs as $k => $arg) {
            if (is_string($arg) && PHPExcel_Calculation_Functions::isValue($k)) {
                return PHPExcel_Calculation_Functions::VALUE();
            }
            if (!is_string($arg) || PHPExcel_Calculation_Functions::isMatrixValue($k)) {
                if (is_numeric($arg) || is_bool($arg) || is_string($arg) & $arg != "") {
                    if (is_bool($arg)) {
                        $arg = (unset) $arg;
                    } else {
                        if (is_string($arg)) {
                            $arg = 0;
                        }
                    }
                    $summerA += $arg * $arg;
                    $summerB += $arg;
                    $aCount++;
                }
            }
        }
        if (0 < $aCount) {
            $summerA *= $aCount;
            $summerB *= $summerB;
            $returnValue = ($summerA - $summerB) / ($aCount * $aCount);
        }
        return $returnValue;
    }
    public static function WEIBULL($value, $alpha, $beta, $cumulative)
    {
        $value = PHPExcel_Calculation_Functions::flattenSingleValue($value);
        $alpha = PHPExcel_Calculation_Functions::flattenSingleValue($alpha);
        $beta = PHPExcel_Calculation_Functions::flattenSingleValue($beta);
        if (is_numeric($value) && is_numeric($alpha) && is_numeric($beta)) {
            if ($value < 0 || $alpha <= 0 || $beta <= 0) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            if (is_numeric($cumulative) || is_bool($cumulative)) {
                if ($cumulative) {
                    return 1 - exp(0 - pow($value / $beta, $alpha));
                }
                return $alpha / pow($beta, $alpha) * pow($value, $alpha - 1) * exp(0 - pow($value / $beta, $alpha));
            }
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }
    public static function ZTEST($dataSet, $m0, $sigma = NULL)
    {
        $dataSet = PHPExcel_Calculation_Functions::flattenArrayIndexed($dataSet);
        $m0 = PHPExcel_Calculation_Functions::flattenSingleValue($m0);
        $sigma = PHPExcel_Calculation_Functions::flattenSingleValue($sigma);
        if (is_null($sigma)) {
            $sigma = $this::STDEV($dataSet);
        }
        $n = count($dataSet);
        return 1 - $this::NORMSDIST(($this::AVERAGE($dataSet) - $m0) / ($sigma / SQRT($n)));
    }
}

?>