/**

 * Youtube search - a TinyMCE youtube search and place plugin

 * youtube/plugin.js

 *

 * This is not free software

 *

 * Plugin info: http://www.cfconsultancy.nl/

 * Author: Ceasar Feijen

 *

 * Version: 3.0 released 28/04/2019

 */

tinymce.PluginManager.requireLangPack('youtube', 'en,nl,de');

tinymce.PluginManager.add('youtube', function(editor, url) {



    function openmanager() {



		if (tinymce.majorVersion > 4) {



		    tinymce.activeEditor.windowManager.openUrl({

	            title: 'Choose YouTube Video',

	            url: tinyMCE.baseURL + '/plugins/youtube/youtube.html',

	            filetype: 'video',

		    	width: 785,

	            height: 630,

	            inline: 1

				});



		} else {



		    tinymce.activeEditor.windowManager.open({

	            title: 'Choose YouTube Video',

	            file: tinyMCE.baseURL + '/plugins/youtube/youtube.html',

	            filetype: 'video',

		    	width: 785,

	            height: 630,

	            inline: 1

				});



		}





    }



	if (tinymce.majorVersion > 4) {



	editor.ui.registry.addButton('youtube', {

		//icon: 'insert-media',

		text: 'Youtube',

		tooltip: 'Insert Youtube video',

		shortcut: 'Ctrl+Q',

		onAction: openmanager

	});



	editor.addShortcut('Ctrl+Q', '', openmanager);



	editor.ui.registry.addMenuItem('youtube', {

		//icon: 'insert-time',

		text: 'Insert Youtube video',

		shortcut: 'Ctrl+Q',

		onAction: openmanager,

		context: 'insert'

	});



	} else {



	editor.addButton('youtube', {

		icon: true,

		image: tinyMCE.baseURL + '/plugins/youtube/icon.png',

		tooltip: 'Insert Youtube video',

		shortcut: 'Ctrl+Q',

		onclick: openmanager

	});



	editor.addShortcut('Ctrl+Q', '', openmanager);



	editor.addMenuItem('youtube', {

		icon:'media',

		text: 'Insert Youtube video',

		shortcut: 'Ctrl+Q',

		onclick: openmanager,

		context: 'insert'

	});



	}

});

